/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.FileContentThreadData;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.MonitorRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private final AbstractFileObject file;
    private Map attrs;
    private Map roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal threadData = new ThreadLocal();

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.file = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getThreadData() {
        FileContentThreadData data = (FileContentThreadData)this.threadData.get();
        if (data == null) {
            data = new FileContentThreadData();
            this.threadData.set(data);
        }
        return data;
    }

    public FileObject getFile() {
        return this.file;
    }

    public long getSize() throws FileSystemException {
        if (!this.file.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.file);
        }
        try {
            return this.file.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.file}, (Throwable)exc);
        }
    }

    public long getLastModifiedTime() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.file);
        }
        try {
            return this.file.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.file, (Throwable)e);
        }
    }

    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.file);
        }
        try {
            this.file.doSetLastModifiedTime(modTime);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.file, (Throwable)e);
        }
    }

    public Map getAttributes() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.file);
        }
        if (this.roAttrs == null) {
            try {
                this.attrs = this.file.doGetAttributes();
                this.roAttrs = Collections.unmodifiableMap(this.attrs);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.file, (Throwable)e);
            }
        }
        return this.roAttrs;
    }

    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set names = this.attrs.keySet();
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(attrName.toLowerCase());
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{attrName, this.file});
        }
        try {
            this.file.doSetAttribute(attrName, value);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{attrName, this.file}, (Throwable)e);
        }
        if (this.attrs != null) {
            this.attrs.put(attrName, value);
        }
    }

    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.file.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.file);
        }
        try {
            Certificate[] certs = this.file.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.file, (Throwable)e);
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        InputStream instr = this.file.getInputStream();
        FileContentInputStream wrappedInstr = new FileContentInputStream(instr);
        this.getThreadData().addInstr(wrappedInstr);
        return wrappedInstr;
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.file.getRandomAccessContent(mode);
        this.getThreadData().setRastr(new FileRandomAccessContent(rastr));
        return this.getThreadData().getRastr();
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        if (this.getThreadData().getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.file);
        }
        OutputStream outstr = this.file.getOutputStream(bAppend);
        this.getThreadData().setOutstr(new FileContentOutputStream(outstr));
        return this.getThreadData().getOutstr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemException {
        block7: {
            try {
                while (this.getThreadData().getInstrsSize() > 0) {
                    FileContentInputStream instr = (FileContentInputStream)this.getThreadData().removeInstr(0);
                    instr.close();
                }
                if (this.getThreadData().getOutstr() != null) {
                    this.getThreadData().closeOutstr();
                }
                if (this.getThreadData().getRastr() == null) break block7;
                try {
                    this.getThreadData().closeRastr();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            finally {
                this.threadData.set(null);
            }
        }
    }

    private void endInput(FileContentInputStream instr) {
        this.getThreadData().removeInstr(instr);
    }

    private void endRandomAccess() {
    }

    private void endOutput() throws Exception {
        this.getThreadData().setOutstr(null);
        this.file.endOutput();
    }

    public boolean isOpen() {
        return this.getThreadData().hasStreams();
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        FileContentOutputStream(OutputStream outstr) {
            super(outstr);
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", DefaultFileContent.this.file, (Throwable)e);
                }
                throw throwable;
            }
            try {
                DefaultFileContent.this.endOutput();
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        FileRandomAccessContent(RandomAccessContent content) {
            super(content);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess();
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        FileContentInputStream(InputStream instr) {
            super(instr);
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

