/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class LayeredFileNameParser
extends AbstractFileNameParser {
    private static final LayeredFileNameParser INSTANCE = new LayeredFileNameParser();

    public static LayeredFileNameParser getInstance() {
        return INSTANCE;
    }

    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '!';
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(filename, name);
        String rootUriName = this.extractRootName(name);
        FileName rootUri = null;
        if (rootUriName != null) {
            rootUri = context.parseURI(rootUriName);
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.normalisePath(name);
        String path = name.toString();
        return new LayeredFileName(scheme, rootUri, path);
    }

    protected String extractRootName(StringBuffer uri) throws FileSystemException {
        int pos;
        int maxlen = uri.length();
        for (pos = maxlen - 1; pos > 0 && uri.charAt(pos) != '!'; --pos) {
        }
        String prefix = uri.substring(0, pos);
        if (pos < maxlen) {
            uri.delete(0, pos + 1);
        } else {
            uri.setLength(0);
        }
        return prefix;
    }
}

