/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.GenericFileName;

public class URLFileName
extends GenericFileName {
    private final String queryString;

    public URLFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, String queryString) {
        super(scheme, hostName, port, defaultPort, userName, password, path);
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQuery() {
        StringBuffer sb = new StringBuffer(250);
        sb.append(this.getPath());
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }

    public String getPathQueryEncoded(String charset) throws URIException, FileSystemException {
        if (this.getQueryString() == null) {
            if (charset != null) {
                return URIUtil.encodePath((String)this.getPathDecoded(), (String)charset);
            }
            return URIUtil.encodePath((String)this.getPathDecoded());
        }
        StringBuffer sb = new StringBuffer(250);
        if (charset != null) {
            sb.append(URIUtil.encodePath((String)this.getPathDecoded(), (String)charset));
        } else {
            sb.append(URIUtil.encodePath((String)this.getPathDecoded()));
        }
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }

    public FileName createName(String absPath) {
        return new URLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), absPath, this.getQueryString());
    }

    protected String createURI() {
        if (this.getQueryString() != null) {
            StringBuffer sb = new StringBuffer(250);
            sb.append(super.createURI());
            sb.append("?");
            sb.append(this.getQueryString());
            return sb.toString();
        }
        return super.createURI();
    }

    public String getURIEncoded(String charset) throws FileSystemException, URIException {
        StringBuffer sb = new StringBuffer(80);
        this.appendRootUri(sb);
        sb.append(this.getPathQueryEncoded(charset));
        return sb.toString();
    }
}

