/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.jar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.jar.JarFileSystem;
import org.apache.commons.vfs.provider.zip.ZipFileProvider;

public class JarFileProvider
extends ZipFileProvider {
    static final Collection capabilities;

    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = new LayeredFileName(scheme, file.getName(), "/");
        return new JarFileSystem(name, file, fileSystemOptions);
    }

    public Collection getCapabilities() {
        return capabilities;
    }

    static {
        ArrayList<Capability> combined = new ArrayList<Capability>();
        combined.addAll(ZipFileProvider.capabilities);
        combined.addAll(Arrays.asList(Capability.ATTRIBUTES, Capability.FS_ATTRIBUTES, Capability.SIGNING, Capability.MANIFEST_ATTRIBUTES, Capability.VIRTUAL));
        capabilities = Collections.unmodifiableCollection(combined);
    }
}

