/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs.provider.local.LocalFile;

public class LocalFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, null, opts);
        this.rootFile = rootFile;
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        String fileName = this.rootFile + name.getPath();
        return new LocalFile(this, fileName, name);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(DefaultLocalFileProvider.capabilities);
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

