/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;

    protected SftpFileObject(FileName name, SftpFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
    }

    protected FileType doGetType() throws Exception {
        this.statSelf();
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            this.attrs = channel.stat(this.getName().getPathDecoded());
        }
        catch (SftpException e) {
            this.attrs = null;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.mkdir(this.getName().getPathDecoded());
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetLastModifiedTime(long modtime) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            int newMTime = (int)(modtime / 1000L);
            this.attrs.setACMODTIME(this.attrs.getATime(), newMTime);
            channel.setStat(this.getName().getPathDecoded(), this.attrs);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channel.rm(this.getName().getPathDecoded());
            } else {
                channel.rmdir(this.getName().getPathDecoded());
            }
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.rename(this.getName().getPathDecoded(), newfile.getName().getPathDecoded());
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] doListChildren() throws Exception {
        Vector vector;
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            vector = channel.ls(this.getName().getPathDecoded());
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<String> children = new ArrayList<String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String stat = (String)iterator.next();
            boolean trigger = true;
            int state = 0;
            StringBuffer nameBuf = new StringBuffer(stat.length());
            for (int i = 0; i < stat.length(); ++i) {
                char c = stat.charAt(i);
                if (state == 16) {
                    nameBuf.append(c);
                    continue;
                }
                if ((c == ' ' || !trigger) && (c != ' ' || trigger)) continue;
                ++state;
                trigger = !trigger;
            }
            String name = nameBuf.toString();
            if (name.equals(".") || name.equals("..")) continue;
            children.add(name);
        }
        return UriParser.encode(children.toArray(new String[children.size()]));
    }

    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SftpRandomAccessContent(this, mode);
    }

    InputStream getInputStream(long filePointer) throws IOException {
        throw new UnsupportedOperationException("Implemented. Yes. But have to wait for jsch release :-)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            channel.get(this.getName().getPathDecoded(), (OutputStream)outstr);
            outstr.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outstr.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        return new SftpOutputStream(channel);
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channel) {
            super(new ByteArrayOutputStream());
            this.channel = channel;
        }

        protected void onClose() throws IOException {
            try {
                ByteArrayOutputStream outstr = (ByteArrayOutputStream)this.out;
                this.channel.put((InputStream)new ByteArrayInputStream(outstr.toByteArray()), SftpFileObject.this.getName().getPathDecoded());
            }
            catch (SftpException e) {
                throw new FileSystemException(e);
            }
            finally {
                SftpFileObject.this.fileSystem.putChannel(this.channel);
            }
        }
    }
}

