/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs.provider.sftp.SftpFileNameParser;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE));
    public static final String ATTR_USER_INFO = "UI";

    public SftpFileProvider() {
        this.setFileNameParser(SftpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        GenericFileName rootName = (GenericFileName)name;
        try {
            session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), rootName.getUserName(), rootName.getPassword(), fileSystemOptions);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", name, (Throwable)e);
        }
        return new SftpFileSystem(rootName, session, fileSystemOptions);
    }

    public void init() throws FileSystemException {
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return SftpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

