/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractLayeredFileProvider;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.zip.ZipFileSystem;

public class ZipFileProvider
extends AbstractLayeredFileProvider
implements FileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.COMPRESS, Capability.VIRTUAL));

    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName rootName = new LayeredFileName(scheme, file.getName(), "/");
        return new ZipFileSystem(rootName, file, fileSystemOptions);
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

