/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    private static final String DEFAULT_CONVERSION_PATTERN = "%m";
    private static final String TTCC_CONVERSION_PATTERN = "%r%t%p%c%x%m";
    private static final String PATTERN_RULE_REGISTRY = "PATTERN_RULE_REGISTRY";
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    public static final String TITLE_OPTION = "Title";
    private static final String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    private String pattern;
    private LoggingEventPatternConverter[] patternConverters;
    private FormattingInfo[] patternFields;
    private String timezone;
    private String title = "Log4J Log Messages";
    private boolean locationInfo;
    private boolean internalCSS = false;
    private String url2ExternalCSS = "http://logging.apache.org/log4j/docs/css/eventTable-1.0.css";
    private boolean chainHandlesThrowable;
    private long counter = 0L;

    public HTMLLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public HTMLLayout(String pattern) {
        this.pattern = pattern;
        this.activateOptions();
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setConversionPattern(String conversionPattern) {
        this.pattern = conversionPattern;
    }

    public String getConversionPattern() {
        return this.pattern;
    }

    public void activateOptions() {
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        Map converterRegistry = null;
        if (this.repository instanceof LoggerRepositoryEx) {
            converterRegistry = (Map)((LoggerRepositoryEx)this.repository).getObject(PATTERN_RULE_REGISTRY);
        }
        PatternParser.parse(this.pattern, converters, fields, converterRegistry, PatternParser.getPatternLayoutRules(), this.getLogger());
        this.patternConverters = new LoggingEventPatternConverter[converters.size()];
        this.patternFields = new FormattingInfo[converters.size()];
        int i = 0;
        Iterator converterIter = converters.iterator();
        Iterator fieldIter = fields.iterator();
        while (converterIter.hasNext()) {
            Object converter = converterIter.next();
            if (converter instanceof LoggingEventPatternConverter) {
                this.patternConverters[i] = (LoggingEventPatternConverter)converter;
                this.chainHandlesThrowable |= this.patternConverters[i].handlesThrowable();
            } else {
                this.patternConverters[i] = new LiteralPatternConverter("");
            }
            this.patternFields[i] = fieldIter.hasNext() ? (FormattingInfo)fieldIter.next() : FormattingInfo.getDefault();
            ++i;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isInternalCSS() {
        return this.internalCSS;
    }

    public void setInternalCSS(boolean internalCSS) {
        this.internalCSS = internalCSS;
    }

    public String getURL2ExternalCSS() {
        return this.url2ExternalCSS;
    }

    public void setURL2ExternalCSS(String url2ExternalCSS) {
        this.url2ExternalCSS = url2ExternalCSS;
    }

    public String getContentType() {
        return "text/html";
    }

    void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeTags(s[0]));
            sbuf.append(Layout.LINE_SEP);
            for (int i = 1; i < len; ++i) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags(s[i]));
                sbuf.append(Layout.LINE_SEP);
            }
        }
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
        sbuf.append(" \"http://www.w3.org/TR/html4/loose.dtd\">");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<html>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<head>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<title>");
        sbuf.append(this.title);
        sbuf.append("</title>");
        sbuf.append(Layout.LINE_SEP);
        if (this.internalCSS) {
            this.getInternalCSS(sbuf);
        } else {
            sbuf.append("<LINK REL=StyleSheet HREF=\"");
            sbuf.append(this.url2ExternalCSS);
            sbuf.append("\" TITLE=\"Basic\">");
        }
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("</head>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<body>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("Log session start time ");
        sbuf.append(new Date());
        sbuf.append("<br>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<br>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\">");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<tr class=\"header\">");
        sbuf.append(Layout.LINE_SEP);
        for (int i = 0; i < this.patternConverters.length; ++i) {
            LoggingEventPatternConverter c = this.patternConverters[i];
            sbuf.append("<td class=\"");
            sbuf.append(c.getStyleClass(null).toLowerCase());
            sbuf.append("\">");
            sbuf.append(c.getName());
            sbuf.append("</td>");
            sbuf.append(Layout.LINE_SEP);
        }
        sbuf.append("</tr>");
        sbuf.append(Layout.LINE_SEP);
        return sbuf.toString();
    }

    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<br>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent event) {
        String[] s;
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(Layout.LINE_SEP);
        buf.append("<tr class=\"");
        buf.append(level);
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(Layout.LINE_SEP);
        for (int i = 0; i < this.patternConverters.length; ++i) {
            LoggingEventPatternConverter c = this.patternConverters[i];
            buf.append("<td class=\"");
            buf.append(c.getStyleClass(event).toLowerCase());
            buf.append("\">");
            int fieldStart = buf.length();
            ((PatternConverter)c).format(event, buf);
            this.patternFields[i].format(fieldStart, buf);
            buf.append("</td>");
            buf.append(Layout.LINE_SEP);
        }
        buf.append("</tr>");
        buf.append(Layout.LINE_SEP);
        if (!this.chainHandlesThrowable && (s = event.getThrowableStrRep()) != null) {
            buf.append("<tr><td class=\"exception\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, buf);
            buf.append("</td></tr>");
            buf.append(Layout.LINE_SEP);
        }
        return buf.toString();
    }

    void getInternalCSS(StringBuffer buf) {
        buf.append("<STYLE  type=\"text/css\">");
        buf.append(Layout.LINE_SEP);
        buf.append("table { margin-left: 2em; margin-right: 2em; border-left: 2px solid #AAA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.even { background: #FFFFFF; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.odd { background: #DADADA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.warn TD.level, TR.error TD.level, TR.fatal TD.level {font-weight: bold; color: #FF4040 }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD { padding-right: 1ex; padding-left: 1ex; border-right: 2px solid #AAA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.time, TD.date { text-align: right; font-family: courier, monospace; font-size: smaller; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.sn { text-align: right; width: 5ex; font-family: courier, monospace; font-size: smaller; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.thread { text-align: left; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.level { text-align: right; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.logger { text-align: left; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.header { background: #9090FF; color: #FFF; font-weight: bold; font-size: larger; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.exception { background: #C0C0F0; font-family: courier, monospace;}");
        buf.append(Layout.LINE_SEP);
        buf.append("</STYLE>");
        buf.append(Layout.LINE_SEP);
    }
}

