/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.ULogger;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.action.ImplicitAction;
import org.apache.log4j.joran.spi.ActionException;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.joran.spi.Pattern;
import org.apache.log4j.joran.spi.RuleStore;
import org.apache.log4j.spi.Component;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.SimpleULogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Interpreter
extends DefaultHandler
implements Component {
    private static List EMPTY_LIST = new Vector(0);
    private RuleStore ruleStore;
    private ExecutionContext ec;
    private ArrayList implicitActions;
    Pattern pattern;
    Locator locator;
    private EntityResolver entityResolver;
    private LoggerRepository repository;
    Stack actionListStack;
    Pattern skip = null;

    public Interpreter(RuleStore rs) {
        this.ruleStore = rs;
        this.ec = new ExecutionContext(this);
        this.implicitActions = new ArrayList(3);
        this.pattern = new Pattern();
        this.actionListStack = new Stack();
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String tagName = this.getTagName(localName, qName);
        this.pattern.push(tagName);
        List applicableActionList = this.getApplicableActionList(this.pattern, atts);
        if (applicableActionList != null) {
            this.actionListStack.add(applicableActionList);
            this.callBeginAction(applicableActionList, tagName, atts);
        } else {
            this.actionListStack.add(EMPTY_LIST);
            String errMsg = "no applicable action for <" + tagName + ">, current pattern is [" + this.pattern + "]";
            this.getLogger().warn(errMsg);
            this.ec.addError(new ErrorItem(errMsg));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        List applicableActionList = (List)this.actionListStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.pattern)) {
                this.getLogger().info((Object)"Normall processing will continue with the next element. Current pattern is <{}>", this.pattern);
                this.skip = null;
            } else {
                this.getLogger().debug((Object)"Skipping invoking end() method for <{}>.", this.pattern);
            }
        } else if (applicableActionList != EMPTY_LIST) {
            this.callEndAction(applicableActionList, this.getTagName(localName, qName));
        }
        this.pattern.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    String getTagName(String localName, String qName) {
        String tagName = localName;
        if (tagName == null || tagName.length() < 1) {
            tagName = qName;
        }
        return tagName;
    }

    public void addImplicitAction(ImplicitAction ia) {
        this.implicitActions.add(ia);
    }

    List lookupImplicitAction(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        int len = this.implicitActions.size();
        for (int i = 0; i < len; ++i) {
            ImplicitAction ia = (ImplicitAction)this.implicitActions.get(i);
            if (!ia.isApplicable(pattern, attributes, ec)) continue;
            ArrayList<ImplicitAction> actionList = new ArrayList<ImplicitAction>(1);
            actionList.add(ia);
            return actionList;
        }
        return null;
    }

    List getApplicableActionList(Pattern pattern, Attributes attributes) {
        List applicableActionList = this.ruleStore.matchActions(pattern);
        if (applicableActionList == null) {
            applicableActionList = this.lookupImplicitAction(pattern, attributes, this.ec);
        }
        return applicableActionList;
    }

    void callBeginAction(List applicableActionList, String tagName, Attributes atts) {
        if (applicableActionList == null) {
            return;
        }
        if (this.skip != null) {
            this.getLogger().debug((Object)"Skipping invoking begin() method for <{}>.", this.pattern);
            return;
        }
        Iterator i = applicableActionList.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            try {
                action.begin(this.ec, tagName, atts);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        this.skip = (Pattern)this.pattern.clone();
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
                this.getLogger().info((Object)"Skip pattern set to <{}>", this.skip);
            }
            catch (Exception e) {
                this.skip = (Pattern)this.pattern.clone();
                this.getLogger().info((Object)"Skip pattern set to <{}>", this.skip);
                this.ec.addError(new ErrorItem("Exception in Action for tag <" + tagName + ">", e));
            }
        }
    }

    void callEndAction(List applicableActionList, String tagName) {
        if (applicableActionList == null) {
            return;
        }
        Iterator i = applicableActionList.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            try {
                action.end(this.ec, tagName);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
                this.getLogger().info((Object)"Skip pattern set to <{}>", this.skip);
            }
            catch (Exception e) {
                this.ec.addError(new ErrorItem("Exception in Action for tag <" + tagName + ">", e));
                this.skip = (Pattern)this.pattern.clone();
                this.skip.pop();
                this.getLogger().info((Object)"Skip pattern set to <{}>.", this.skip);
            }
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    public void setRuleStore(RuleStore ruleStore) {
        this.ruleStore = ruleStore;
    }

    public void error(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing error", spe));
        this.getLogger().error((Object)("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber()), spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing fatal error", spe));
        this.getLogger().error((Object)("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber()), spe);
    }

    public void warning(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing warning", spe));
        this.getLogger().warn((Object)("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber()), spe);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.entityResolver == null) {
            return null;
        }
        try {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void setLoggerRepository(LoggerRepository repository) {
        this.repository = repository;
    }

    protected ULogger getLogger() {
        if (this.repository != null) {
            return this.repository.getLogger(this.getClass().getName());
        }
        return SimpleULogger.getLogger(this.getClass().getName());
    }
}

