/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class SocketAppender
extends AppenderSkeleton {
    public static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    private static final int RESET_FREQUENCY = 1;
    String remoteHost;
    InetAddress address;
    int port = 4560;
    ObjectOutputStream oos;
    int reconnectionDelay = 30000;
    boolean locationInfo = false;
    private Connector connector;
    int counter = 0;
    String hostname;
    String application;

    public SocketAppender() {
        super(false);
    }

    public SocketAppender(InetAddress address, int port) {
        super(false);
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
        this.activateOptions();
    }

    public SocketAppender(String host, int port) {
        super(false);
        this.port = port;
        this.address = this.getAddressByName(host);
        this.remoteHost = host;
        this.activateOptions();
    }

    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe2) {
                this.hostname = "unknown";
            }
        }
        if (this.remoteHost == null) {
            String err = "The RemoteHost property is required for SocketAppender named " + this.name;
            this.getLogger().error(err);
            throw new IllegalStateException(err);
        }
        this.address = this.getAddressByName(this.remoteHost);
        this.connect(this.address, this.port);
        super.activateOptions();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                this.getLogger().error((Object)"Could not close oos.", e);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(address, port).getOutputStream());
        }
        catch (IOException e) {
            String msg = "Could not connect to remote log4j server at [" + address.getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                msg = msg + " We will try again later.";
                this.fireConnector();
            }
            this.getLogger().error(msg + "(" + e.getMessage() + ")");
        }
    }

    public void append(LoggingEvent event) {
        block8: {
            if (event == null) {
                return;
            }
            if (this.oos != null) {
                try {
                    if (this.locationInfo) {
                        event.getLocationInformation();
                    }
                    if (this.hostname != null) {
                        event.setProperty("hostname", this.hostname);
                    }
                    if (this.application != null) {
                        event.setProperty("application", this.application);
                    }
                    this.oos.writeObject(event);
                    this.oos.flush();
                    if (++this.counter >= 1) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException e) {
                    this.oos = null;
                    this.getLogger().warn("Detected problem with connection: " + e);
                    if (this.reconnectionDelay <= 0) break block8;
                    this.fireConnector();
                }
            }
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            this.getLogger().debug("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Could not find address of [" + host + "]."), e);
            return null;
        }
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setApplication(String lapp) {
        this.application = lapp;
    }

    public String getApplication() {
        return this.application;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public boolean requiresLayout() {
        return false;
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketAppender.this.reconnectionDelay);
                    SocketAppender.this.getLogger().debug((Object)"Attempting connection to {}", SocketAppender.this.address.getHostName());
                    Socket socket = new Socket(SocketAppender.this.address, SocketAppender.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppender.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppender.this.connector = null;
                        SocketAppender.this.getLogger().debug("Connection established. Exiting connector thread.");
                        break;
                    }
                }
                catch (InterruptedException e) {
                    SocketAppender.this.getLogger().debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    SocketAppender.this.getLogger().debug("Remote host " + SocketAppender.this.address.getHostName() + " refused connection.");
                }
                catch (IOException e) {
                    SocketAppender.this.getLogger().debug("Could not connect to {}. Exception is {}", SocketAppender.this.address.getHostName(), e);
                }
            }
        }
    }
}

