/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import org.apache.log4j.Appender;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public final class FilterBasedTriggeringPolicy
implements TriggeringPolicy {
    private Filter headFilter;
    private Filter tailFilter;

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String file, long fileLength) {
        if (this.headFilter == null) {
            return false;
        }
        for (Filter f = this.headFilter; f != null; f = f.getNext()) {
            switch (f.decide(event)) {
                case -1: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public void activateOptions() {
        for (Filter f = this.headFilter; f != null; f = f.getNext()) {
            f.activateOptions();
        }
    }
}

