/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.spi.ThrowableInformation;

public class LoggingEvent
implements Serializable {
    private static long startTime = System.currentTimeMillis();
    static final long serialVersionUID = -868428216207166145L;
    static final Integer[] PARAM_ARRAY = new Integer[1];
    static final String TO_LEVEL = "toLevel";
    static final Class[] TO_LEVEL_PARAMS = new Class[]{Integer.TYPE};
    static final Hashtable methodCache = new Hashtable(3);
    static long sequenceCount = 1L;
    public transient String fqnOfCategoryClass;
    private transient Category logger;
    private transient LoggerRepository loggerRepository;
    public String categoryName;
    public transient Priority level;
    private String ndc;
    private Map properties;
    private boolean ndcLookupRequired = true;
    private transient Object message;
    private String renderedMessage;
    private String threadName;
    private ThrowableInformation throwableInfo;
    public long timeStamp;
    long sequenceNumber;
    private LocationInfo locationInfo;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggingEvent;
    static /* synthetic */ Class class$org$apache$log4j$Level;

    public static long getSequenceCount() {
        return sequenceCount;
    }

    public LoggingEvent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEvent(String fqnOfLoggerClass, Category logger, Priority level, Object message, Throwable throwable) {
        this.fqnOfCategoryClass = fqnOfLoggerClass;
        this.logger = logger;
        this.categoryName = logger.getName();
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.timeStamp = System.currentTimeMillis();
        Class clazz = class$org$apache$log4j$spi$LoggingEvent == null ? (class$org$apache$log4j$spi$LoggingEvent = LoggingEvent.class$("org.apache.log4j.spi.LoggingEvent")) : class$org$apache$log4j$spi$LoggingEvent;
        synchronized (clazz) {
            this.sequenceNumber = sequenceCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Priority level, Object message, Throwable throwable) {
        this.fqnOfCategoryClass = fqnOfCategoryClass;
        this.logger = logger;
        this.categoryName = logger.getName();
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.timeStamp = timeStamp;
        Class clazz = class$org$apache$log4j$spi$LoggingEvent == null ? (class$org$apache$log4j$spi$LoggingEvent = LoggingEvent.class$("org.apache.log4j.spi.LoggingEvent")) : class$org$apache$log4j$spi$LoggingEvent;
        synchronized (clazz) {
            this.sequenceNumber = sequenceCount++;
        }
    }

    public boolean equals(Object rObject) {
        if (this == rObject) {
            return true;
        }
        if (!(rObject instanceof LoggingEvent)) {
            return false;
        }
        LoggingEvent rEvent = (LoggingEvent)rObject;
        if (this.timeStamp != rEvent.timeStamp) {
            return false;
        }
        if (this.sequenceNumber != rEvent.sequenceNumber) {
            return false;
        }
        return !(this.categoryName != null && rEvent.categoryName != null ? this.categoryName.length() != rEvent.categoryName.length() : this.categoryName != rEvent.categoryName);
    }

    public int hashCode() {
        return (int)(this.timeStamp >> 20 ^ this.sequenceNumber & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean locationInformationExists() {
        return this.locationInfo != null;
    }

    public LocationInfo getLocationInformation() {
        if (this.locationInfo == null && this.fqnOfCategoryClass != null) {
            this.locationInfo = new LocationInfo(new Throwable(), this.fqnOfCategoryClass);
        }
        return this.locationInfo;
    }

    public void setLocationInformation(LocationInfo li) {
        if (this.locationInfo != null) {
            throw new IllegalStateException("LocationInformation has been already set.");
        }
        this.locationInfo = li;
    }

    public Level getLevel() {
        return (Level)this.level;
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = level;
    }

    public Logger getLogger() {
        if (this.logger instanceof Logger) {
            return (Logger)this.logger;
        }
        return null;
    }

    public void setLogger(Logger logger) {
        if (this.logger != null) {
            throw new IllegalStateException("logger has been already set to [" + this.logger.getName() + "].");
        }
        if (this.categoryName != null) {
            throw new IllegalStateException("loggerName has been already set to [" + this.categoryName + "], logger " + logger.getName() + "] is invalid");
        }
        this.logger = logger;
        this.categoryName = logger.getName();
    }

    public String getLoggerName() {
        return this.categoryName;
    }

    public void setLoggerName(String loggerName) throws IllegalStateException {
        if (this.categoryName != null) {
            throw new IllegalStateException("loggerName has been already set to [" + this.categoryName + "].");
        }
        this.categoryName = loggerName;
    }

    public Object getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.getRenderedMessage();
    }

    public void setMessage(Object message) {
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set alredy.");
        }
        if (this.renderedMessage != null) {
            throw new IllegalStateException("The message cannot be set if the renderedMessage has been set.");
        }
        this.message = message;
    }

    public String getNDC() {
        if (this.ndcLookupRequired) {
            this.ndcLookupRequired = false;
            this.ndc = NDC.get();
        }
        return this.ndc;
    }

    public void setNDC(String ndcString) {
        if (this.ndc != null) {
            throw new IllegalStateException("The ndc has been already set.");
        }
        this.ndcLookupRequired = false;
        this.ndc = ndcString;
    }

    public void initializeProperties() {
        if (this.properties == null) {
            LoggerRepository repo;
            this.properties = new TreeMap();
            Hashtable mdcMap = MDC.getContext();
            if (mdcMap != null) {
                this.properties.putAll(mdcMap);
            }
            if (this.logger != null && (repo = this.logger.getLoggerRepository()) instanceof LoggerRepositoryEx) {
                this.properties.putAll(((LoggerRepositoryEx)repo).getProperties());
            }
        }
    }

    public String getProperty(String key) {
        LoggerRepository repo;
        String value = null;
        if (this.properties != null && (value = (String)this.properties.get(key)) != null) {
            return value;
        }
        Object mdcvalue = MDC.get(key);
        if (mdcvalue != null) {
            return mdcvalue.toString();
        }
        if (this.logger != null && (repo = this.logger.getLoggerRepository()) instanceof LoggerRepositoryEx) {
            value = ((LoggerRepositoryEx)repo).getProperty(key);
        }
        return value;
    }

    public Set getPropertyKeySet() {
        this.initializeProperties();
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getRenderedMessage() {
        if (this.renderedMessage == null && this.message != null) {
            if (this.message instanceof String) {
                this.renderedMessage = (String)this.message;
            } else {
                LoggerRepository repository = this.logger.getLoggerRepository();
                if (repository instanceof RendererSupport) {
                    RendererSupport rs = (RendererSupport)((Object)repository);
                    this.renderedMessage = rs.getRendererMap().findAndRender(this.message);
                } else {
                    this.renderedMessage = this.message.toString();
                }
            }
        }
        return this.renderedMessage;
    }

    public void setRenderedMessage(String renderedMessage) throws IllegalStateException {
        if (this.renderedMessage != null) {
            throw new IllegalStateException("renderedMessage has been already set.");
        }
        this.renderedMessage = renderedMessage;
    }

    public static long getStartTime() {
        return startTime;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public void setThreadName(String threadName) throws IllegalStateException {
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public String[] getThrowableStrRep() {
        if (this.throwableInfo == null) {
            return null;
        }
        return this.throwableInfo.getThrowableStrRep();
    }

    public void setThrowableInformation(ThrowableInformation ti) {
        if (this.throwableInfo != null) {
            throw new IllegalStateException("ThrowableInformation has been already set.");
        }
        this.throwableInfo = ti;
    }

    private void readLevel(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int p = ois.readInt();
        try {
            String className = (String)ois.readObject();
            if (className == null) {
                this.level = Level.toLevel(p);
            } else {
                Method m = (Method)methodCache.get(className);
                if (m == null) {
                    Class clazz = Loader.loadClass(className);
                    m = clazz.getDeclaredMethod(TO_LEVEL, TO_LEVEL_PARAMS);
                    methodCache.put(className, m);
                }
                LoggingEvent.PARAM_ARRAY[0] = new Integer(p);
                this.level = (Level)m.invoke(null, (Object[])PARAM_ARRAY);
            }
        }
        catch (Exception e) {
            this.level = Level.toLevel(p);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.readLevel(ois);
        if (this.locationInfo == null) {
            this.locationInfo = LocationInfo.NA_LOCATION_INFO;
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.initializeProperties();
        }
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public void prepareForDeferredProcessing() {
        this.getThreadName();
        this.getRenderedMessage();
        this.getNDC();
        if (this.properties == null) {
            this.initializeProperties();
        }
        this.getThrowableStrRep();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.prepareForDeferredProcessing();
        oos.defaultWriteObject();
        this.writeLevel(oos);
    }

    private void writeLevel(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.level.toInt());
        Class<?> clazz = this.level.getClass();
        if (clazz == (class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = LoggingEvent.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level)) {
            oos.writeObject(null);
        } else {
            oos.writeObject(clazz.getName());
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getFQNOfLoggerClass() {
        return this.fqnOfCategoryClass;
    }

    public void setFQNOfLoggerClass(String fqnOfLoggerClass) {
        this.fqnOfCategoryClass = fqnOfLoggerClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

