/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.vfs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.log4j.chainsaw.receivers.VisualReceiver;
import org.apache.log4j.varia.LogFilePatternReceiver;

public class VFSLogFilePatternReceiver
extends LogFilePatternReceiver
implements VisualReceiver {
    private Reader reader;
    private boolean promptForUserInfo = false;
    private Container container;
    private Object waitForContainerLock = new Object();
    static /* synthetic */ Class class$0;

    public void shutdown() {
        this.container = null;
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException ioe) {
                this.getLogger().warn((Object)"Unable to close reader", (Throwable)ioe);
            }
        }
    }

    public void setPromptForUserInfo(boolean promptForUserInfo) {
        this.promptForUserInfo = promptForUserInfo;
    }

    public boolean isPromptForUserInfo() {
        return this.promptForUserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        if (this.promptForUserInfo) {
            Object object = this.waitForContainerLock;
            synchronized (object) {
                this.container = container;
                this.waitForContainerLock.notify();
            }
        }
    }

    public void activateOptions() {
        if (this.promptForUserInfo) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Frame containerFrame1;
                    Object object = VFSLogFilePatternReceiver.this.waitForContainerLock;
                    synchronized (object) {
                        while (VFSLogFilePatternReceiver.this.container == null) {
                            try {
                                VFSLogFilePatternReceiver.this.waitForContainerLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    Object object2 = VFSLogFilePatternReceiver.this.waitForContainerLock;
                    synchronized (object2) {
                        while (true) {
                            Class<?> clazz;
                            if ((clazz = class$0) == null) {
                                try {
                                    clazz = Class.forName("java.awt.Frame");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((containerFrame1 = (Frame)SwingUtilities.getAncestorOfClass(clazz, VFSLogFilePatternReceiver.this.container)) != null) {
                                break;
                            }
                            try {
                                VFSLogFilePatternReceiver.this.waitForContainerLock.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    final Frame containerFrame = containerFrame1;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            UserNamePasswordDialog f = new UserNamePasswordDialog(containerFrame);
                            f.pack();
                            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                            f.setLocation(d.width / 2, d.height / 2);
                            f.setVisible(true);
                            if (f.getUserName() == null || f.getPassword() == null) {
                                VFSLogFilePatternReceiver.this.getLogger().warn((Object)("No username or password provided - not loading file " + VFSLogFilePatternReceiver.this.getFileURL()));
                            } else {
                                int index = VFSLogFilePatternReceiver.this.getFileURL().indexOf("://");
                                String firstPart = VFSLogFilePatternReceiver.this.getFileURL().substring(0, index);
                                String lastPart = VFSLogFilePatternReceiver.this.getFileURL().substring(index + "://".length());
                                VFSLogFilePatternReceiver.this.setFileURL(String.valueOf(firstPart) + "://" + f.getUserName() + ":" + new String(f.getPassword()) + "@" + lastPart);
                                new Thread(new VFSReader()).start();
                            }
                        }
                    });
                }
            }).start();
        } else {
            new Thread(new VFSReader()).start();
        }
    }

    private class VFSReader
    implements Runnable {
        VFSReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (VFSLogFilePatternReceiver.this.reader == null) {
                VFSLogFilePatternReceiver.this.getLogger().info((Object)("attempting to load file: " + VFSLogFilePatternReceiver.this.getFileURL()));
                try {
                    FileSystemManager fileSystemManager = VFS.getManager();
                    FileObject fileObject = fileSystemManager.resolveFile(VFSLogFilePatternReceiver.this.getFileURL());
                    VFSLogFilePatternReceiver.this.reader = new InputStreamReader(fileObject.getContent().getInputStream());
                    if (!(fileObject.getName() instanceof URLFileName)) continue;
                    URLFileName urlFileName = (URLFileName)fileObject.getName();
                    VFSLogFilePatternReceiver.this.setHost(urlFileName.getHostName());
                    VFSLogFilePatternReceiver.this.setPath(urlFileName.getPath());
                }
                catch (FileSystemException fse) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)"file not available - will try again in 10 seconds");
                    VFSReader vFSReader = this;
                    synchronized (vFSReader) {
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            VFSLogFilePatternReceiver.this.initialize();
            try {
                VFSLogFilePatternReceiver.this.process(VFSLogFilePatternReceiver.this.reader);
            }
            catch (IOException ioe) {
                VFSLogFilePatternReceiver.this.getLogger().info((Object)"stream closed");
            }
        }
    }

    public class UserNamePasswordDialog
    extends JDialog {
        private String userName;
        private char[] password;

        private UserNamePasswordDialog(Frame containerFrame) {
            super(containerFrame, "Login", true);
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 0;
            gc.anchor = 11;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            gc.insets = new Insets(7, 7, 7, 7);
            panel.add((Component)new JLabel("URI: " + VFSLogFilePatternReceiver.this.getFileURL()), gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel("Username"), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            gc.fill = 2;
            final JTextField userNameTextField = new JTextField(15);
            panel.add((Component)userNameTextField, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 1;
            gc.fill = 0;
            panel.add((Component)new JLabel("Password"), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.gridwidth = 2;
            gc.fill = 2;
            final JPasswordField passwordTextField = new JPasswordField(15);
            panel.add((Component)passwordTextField, gc);
            gc.gridy = 3;
            gc.anchor = 15;
            gc.fill = 0;
            JButton submitButton = new JButton("Submit");
            panel.add((Component)submitButton, gc);
            this.getContentPane().add(panel);
            submitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    UserNamePasswordDialog.this.userName = userNameTextField.getText();
                    UserNamePasswordDialog.this.password = passwordTextField.getPassword();
                    UserNamePasswordDialog.this.getContentPane().setVisible(false);
                    UserNamePasswordDialog.this.dispose();
                }
            });
        }

        public String getUserName() {
            return this.userName;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

