/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.db.dialect.Util;
import org.apache.log4j.spi.ComponentBase;

public abstract class ConnectionSourceSkeleton
extends ComponentBase
implements ConnectionSource {
    private String user = null;
    private String password = null;
    private int dialectCode = 0;
    private boolean supportsGetGeneratedKeys = false;
    private boolean supportsBatchUpdates = false;

    public void discoverConnnectionProperties() {
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                this.getLogger().warn((Object)"Could not get a conneciton");
                return;
            }
            DatabaseMetaData meta = connection.getMetaData();
            Util util = new Util();
            util.setLoggerRepository(this.repository);
            this.supportsGetGeneratedKeys = util.supportsGetGeneratedKeys(meta);
            this.supportsBatchUpdates = util.supportsBatchUpdates(meta);
            this.dialectCode = Util.discoverSQLDialect(meta);
        }
        catch (SQLException se) {
            this.getLogger().warn((Object)"Could not discover the dialect to use.", (Throwable)se);
        }
    }

    public final boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public final int getSQLDialectCode() {
        return this.dialectCode;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String username) {
        this.user = username;
    }

    public final boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }
}

