/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.db.DBReceiverJob;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.scheduler.Scheduler;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;

public class DBReceiver
extends Receiver
implements Pauseable {
    static int DEFAULT_REFRESH_MILLIS = 1000;
    ConnectionSource connectionSource;
    int refreshMillis = DEFAULT_REFRESH_MILLIS;
    DBReceiverJob receiverJob;
    boolean paused = false;
    private static final LoggerRepository Hierarchy = null;

    public void activateOptions() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.receiverJob = new DBReceiverJob(this);
        this.receiverJob.setLoggerRepository(this.repository);
        if (this.repository == null) {
            throw new IllegalStateException("DBAppender cannot function without a reference to its owning repository");
        }
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.schedule((Job)this.receiverJob, System.currentTimeMillis() + 500L, (long)this.refreshMillis);
        }
    }

    public void setRefreshMillis(int refreshMillis) {
        this.refreshMillis = refreshMillis;
    }

    public int getRefreshMillis() {
        return this.refreshMillis;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void shutdown() {
        this.getLogger().info((Object)"removing receiverJob from the Scheduler.");
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.delete((Job)this.receiverJob);
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

