/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.db.ConnectionSourceSkeleton;

public class DataSourceConnectionSource
extends ConnectionSourceSkeleton {
    private DataSource dataSource;

    public void activateOptions() {
        if (this.dataSource == null) {
            this.getLogger().warn((Object)"WARNING: No data source specified");
        } else {
            Connection connection = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException se) {
                this.getLogger().warn((Object)"Could not get a connection to discover the dialect to use.", (Throwable)se);
            }
            if (connection != null) {
                this.discoverConnnectionProperties();
            }
            if (!this.supportsGetGeneratedKeys() && this.getSQLDialectCode() == 0) {
                this.getLogger().warn((Object)"Connection does not support GetGeneratedKey method and could not discover the dialect.");
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            this.getLogger().error((Object)"WARNING: No data source specified");
            return null;
        }
        if (this.getUser() == null) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(this.getUser(), this.getPassword());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

