/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class TelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;

    public TelnetAppender() {
        super(false);
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            this.sh = new SocketHandler(this.port);
            this.sh.start();
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Could not active TelnetAppender options for TelnetAppender named " + this.getName()), (Throwable)e);
            throw new IllegalStateException("Could not create a SocketHandler for TelnetAppender named " + this.getName());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void close() {
        if (this.sh != null) {
            this.sh.finalize();
        }
    }

    protected void append(LoggingEvent event) {
        String[] s;
        if (this.sh == null || !this.sh.hasConnections()) {
            return;
        }
        this.sh.send(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            for (int i = 0; i < len; ++i) {
                this.sh.send(s[i]);
                this.sh.send(Layout.LINE_SEP);
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private boolean done = false;
        private Vector writers = new Vector();
        private Vector connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;
        private String encoding = "UTF-8";

        public SocketHandler(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
        }

        public void finalize() {
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                try {
                    ((Socket)e.nextElement()).close();
                }
                catch (Exception exception) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.done = true;
        }

        public void send(String message) {
            boolean hasWriterError = false;
            Enumeration e = this.writers.elements();
            while (e.hasMoreElements()) {
                PrintWriter writer = (PrintWriter)e.nextElement();
                writer.print(message);
                hasWriterError |= writer.checkError();
            }
            if (hasWriterError) {
                for (int i = this.writers.size() - 1; i >= 0; --i) {
                    if (!((PrintWriter)this.writers.elementAt(i)).checkError()) continue;
                    this.writers.remove(i);
                    this.connections.remove(i);
                }
            }
        }

        public void run() {
            while (!this.done) {
                try {
                    Socket newClient = this.serverSocket.accept();
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(newClient.getOutputStream(), this.encoding));
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        this.connections.addElement(newClient);
                        this.writers.addElement(pw);
                        pw.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                        pw.flush();
                        continue;
                    }
                    pw.print("Too many connections.\r\n");
                    pw.flush();
                    newClient.close();
                }
                catch (Exception e) {
                    TelnetAppender.this.getLogger().error((Object)"Encountered error while in SocketHandler loop.", (Throwable)e);
                }
            }
        }

        public boolean hasConnections() {
            return this.connections.size() > 0;
        }
    }
}

