/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDecoder
implements Decoder {
    private static final String BEGINPART = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE log4j:eventSet SYSTEM \"log4j.dtd\"><log4j:eventSet version=\"1.2\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">";
    private static final String ENDPART = "</log4j:eventSet>";
    private static final String RECORD_END = "</log4j:event>";
    private DocumentBuilderFactory dbf;
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private Component owner = null;

    public XMLDecoder(Component owner) {
        this();
        this.owner = owner;
    }

    public XMLDecoder() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setValidating(false);
        try {
            this.docBuilder = this.dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler(new SAXErrorHandler());
            this.docBuilder.setEntityResolver(new Log4jEntityResolver());
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Unable to get document builder");
        }
    }

    public void setAdditionalProperties(Map additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private Document parse(String data) {
        if (this.docBuilder == null || data == null) {
            return null;
        }
        Document document = null;
        try {
            StringBuffer buf = new StringBuffer(1024);
            buf.append(BEGINPART);
            buf.append(data);
            buf.append(ENDPART);
            InputSource inputSource = new InputSource(new StringReader(buf.toString()));
            inputSource.setSystemId("dummy://log4j.dtd");
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector decode(URL url) throws IOException {
        LineNumberReader reader = null;
        reader = this.owner != null ? new LineNumberReader(new InputStreamReader(new ProgressMonitorInputStream(this.owner, "Loading " + url, url.openStream()))) : new LineNumberReader(new InputStreamReader(url.openStream()));
        Vector v = new Vector();
        String line = null;
        Vector events = null;
        try {
            while ((line = reader.readLine()) != null) {
                StringBuffer buffer = new StringBuffer(line);
                for (int i = 0; i < 1000; ++i) {
                    buffer.append(reader.readLine()).append("\n");
                }
                events = this.decodeEvents(buffer.toString());
                if (events == null) continue;
                v.addAll(events);
            }
        }
        finally {
            this.partialEvent = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    public Vector decodeEvents(String document) {
        if (document != null) {
            if (document.trim().equals("")) {
                return null;
            }
            String newDoc = null;
            String newPartialEvent = null;
            if (document.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + document;
                return null;
            }
            if (document.lastIndexOf(RECORD_END) + RECORD_END.length() < document.length()) {
                newDoc = document.substring(0, document.lastIndexOf(RECORD_END) + RECORD_END.length());
                newPartialEvent = document.substring(document.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                newDoc = document;
            }
            if (this.partialEvent != null) {
                newDoc = this.partialEvent + newDoc;
            }
            this.partialEvent = newPartialEvent;
            Document doc = this.parse(newDoc);
            if (doc == null) {
                return null;
            }
            return this.decodeEvents(doc);
        }
        return null;
    }

    public LoggingEvent decode(String data) {
        Document document = this.parse(data);
        if (document == null) {
            return null;
        }
        Vector events = this.decodeEvents(document);
        if (events.size() > 0) {
            return (LoggingEvent)events.firstElement();
        }
        return null;
    }

    private Vector decodeEvents(Document document) {
        Vector<LoggingEvent> events = new Vector<LoggingEvent>();
        Logger logger = null;
        long timeStamp = 0L;
        String level = null;
        String threadName = null;
        String message = null;
        String ndc = null;
        String[] exception = null;
        String className = null;
        String methodName = null;
        String fileName = null;
        String lineNumber = null;
        Hashtable<String, String> properties = null;
        NodeList nl = document.getElementsByTagName("log4j:eventSet");
        Node eventSet = nl.item(0);
        NodeList eventList = eventSet.getChildNodes();
        for (int eventIndex = 0; eventIndex < eventList.getLength(); ++eventIndex) {
            Node eventNode = eventList.item(eventIndex);
            if (eventNode.getNodeType() != 1) continue;
            logger = Logger.getLogger((String)eventNode.getAttributes().getNamedItem("logger").getNodeValue());
            timeStamp = Long.parseLong(eventNode.getAttributes().getNamedItem("timestamp").getNodeValue());
            level = eventNode.getAttributes().getNamedItem("level").getNodeValue();
            threadName = eventNode.getAttributes().getNamedItem("thread").getNodeValue();
            NodeList list = eventNode.getChildNodes();
            int listLength = list.getLength();
            for (int y = 0; y < listLength; ++y) {
                String value;
                String name;
                Node property;
                String propertyTag;
                int i;
                int propertyLength;
                NodeList propertyList;
                String tagName = list.item(y).getNodeName();
                if (tagName.equalsIgnoreCase("log4j:message")) {
                    message = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("log4j:NDC")) {
                    ndc = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("log4j:MDC")) {
                    properties = new Hashtable<String, String>();
                    propertyList = list.item(y).getChildNodes();
                    propertyLength = propertyList.getLength();
                    for (i = 0; i < propertyLength; ++i) {
                        propertyTag = propertyList.item(i).getNodeName();
                        if (!propertyTag.equalsIgnoreCase("log4j:data")) continue;
                        property = propertyList.item(i);
                        name = property.getAttributes().getNamedItem("name").getNodeValue();
                        value = property.getAttributes().getNamedItem("value").getNodeValue();
                        properties.put(name, value);
                    }
                }
                if (tagName.equalsIgnoreCase("log4j:throwable")) {
                    exception = new String[]{this.getCData(list.item(y))};
                }
                if (tagName.equalsIgnoreCase("log4j:locationinfo")) {
                    className = list.item(y).getAttributes().getNamedItem("class").getNodeValue();
                    methodName = list.item(y).getAttributes().getNamedItem("method").getNodeValue();
                    fileName = list.item(y).getAttributes().getNamedItem("file").getNodeValue();
                    lineNumber = list.item(y).getAttributes().getNamedItem("line").getNodeValue();
                }
                if (tagName.equalsIgnoreCase("log4j:properties")) {
                    if (properties == null) {
                        properties = new Hashtable();
                    }
                    propertyList = list.item(y).getChildNodes();
                    propertyLength = propertyList.getLength();
                    for (i = 0; i < propertyLength; ++i) {
                        propertyTag = propertyList.item(i).getNodeName();
                        if (!propertyTag.equalsIgnoreCase("log4j:data")) continue;
                        property = propertyList.item(i);
                        name = property.getAttributes().getNamedItem("name").getNodeValue();
                        value = property.getAttributes().getNamedItem("value").getNodeValue();
                        properties.put(name, value);
                    }
                }
                if (this.additionalProperties.size() <= 0) continue;
                if (properties == null) {
                    properties = new Hashtable(this.additionalProperties);
                    continue;
                }
                Iterator i2 = this.additionalProperties.entrySet().iterator();
                while (i2.hasNext()) {
                    Map.Entry e = i2.next();
                    if (properties.containsKey(e.getKey())) continue;
                    properties.put((String)e.getKey(), (String)e.getValue());
                }
            }
            Level levelImpl = Level.toLevel((String)level);
            LocationInfo info = null;
            info = fileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(fileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
            if (exception == null) {
                exception = new String[]{""};
            }
            LoggingEvent loggingEvent = new LoggingEvent();
            loggingEvent.setLogger(logger);
            loggingEvent.setTimeStamp(timeStamp);
            loggingEvent.setLevel(levelImpl);
            loggingEvent.setThreadName(threadName);
            loggingEvent.setMessage((Object)message);
            loggingEvent.setNDC(ndc);
            loggingEvent.setThrowableInformation(new ThrowableInformation(exception));
            loggingEvent.setLocationInformation(info);
            loggingEvent.setProperties(properties);
            events.add(loggingEvent);
            logger = null;
            timeStamp = 0L;
            level = null;
            threadName = null;
            message = null;
            ndc = null;
            exception = null;
            className = null;
            methodName = null;
            fileName = null;
            lineNumber = null;
            properties = null;
        }
        return events;
    }

    private String getCData(Node n) {
        StringBuffer buf = new StringBuffer();
        NodeList nl = n.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            Node innerNode = nl.item(x);
            if (innerNode.getNodeType() != 3 && innerNode.getNodeType() != 4) continue;
            buf.append(innerNode.getNodeValue());
        }
        return buf.toString();
    }
}

