/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.log4j.Level;
import org.apache.log4j.net.SocketHubAppender;
import org.apache.log4j.net.Zeroconf4log4j;

public class ZeroConfSocketHubAppender
extends SocketHubAppender {
    public static final String DEFAULT_ZEROCONF_ZONE = "_log4j._tcp.local.";
    private String zeroConfZone = "_log4j._tcp.local.";
    private Object logger;
    private Method logInfoMethod;
    private Method logErrorMethod;
    static /* synthetic */ Class class$0;

    public ZeroConfSocketHubAppender() {
        this.setName("SocketHubAppender");
        try {
            Method getLoggerMethod = ((Object)((Object)this)).getClass().getMethod("getLogger", new Class[0]);
            this.logger = getLoggerMethod.invoke((Object)this, new Object[0]);
            Class<?> clazz = this.logger.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.logInfoMethod = clazz.getMethod("info", classArray);
            Class<?> clazz3 = this.logger.getClass();
            Class[] classArray2 = new Class[1];
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz4;
            this.logErrorMethod = clazz3.getMethod("error", classArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void activateOptions() {
        super.activateOptions();
        try {
            JmDNS jmDNS = Zeroconf4log4j.getInstance();
            ServiceInfo info = this.buildServiceInfo();
            this.logWithlog4j12Compatibility(Level.INFO, "Registering this SocketHubAppender as :" + info);
            jmDNS.registerService(info);
        }
        catch (IOException e) {
            this.logWithlog4j12Compatibility(Level.ERROR, "Failed to instantiate JmDNS to broadcast via ZeroConf, will now operate in simple SocketHubAppender mode");
        }
    }

    private ServiceInfo buildServiceInfo() {
        return new ServiceInfo(this.zeroConfZone, this.getName(), this.getPort(), "SocketHubAppender on port " + this.getPort());
    }

    private void logWithlog4j12Compatibility(Level level, String message) {
        if (this.logger != null && this.logInfoMethod != null & this.logErrorMethod != null) {
            try {
                switch (level.toInt()) {
                    case 20000: {
                        this.logInfoMethod.invoke(this.logger, message);
                        break;
                    }
                    case 40000: {
                        this.logInfoMethod.invoke(this.logger, message);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getZeroConfZone() {
        return this.zeroConfZone;
    }

    public void setZeroConfZone(String zeroConfZone) {
        this.zeroConfZone = zeroConfZone;
    }

    public synchronized void close() {
        super.close();
        try {
            JmDNS jmDNS = Zeroconf4log4j.getInstance();
            ServiceInfo info = this.buildServiceInfo();
            this.logWithlog4j12Compatibility(Level.INFO, "Deregistering this SocketHubAppender (" + info + ")");
            jmDNS.unregisterService(info);
        }
        catch (Exception e) {
            this.logWithlog4j12Compatibility(Level.ERROR, "Failed to instantiate JmDNS to broadcast via ZeroConf, will now operate in simple SocketHubAppender mode");
        }
    }
}

