/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

class DefaultEvaluator
extends ComponentBase
implements TriggeringEventEvaluator {
    private Rule expressionRule;
    private String expression;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void activateOptions() {
        if (this.expression != null) {
            try {
                this.expressionRule = ExpressionRule.getRule((String)this.expression);
            }
            catch (IllegalArgumentException iae) {
                this.getLogger().error((Object)"Unable to use provided expression - falling back to default behavior (trigger on ERROR or greater severity)", (Throwable)iae);
            }
        }
    }

    public boolean isTriggeringEvent(LoggingEvent event) {
        if (this.expressionRule == null) {
            return event.getLevel().isGreaterOrEqual((Priority)Level.ERROR);
        }
        return this.expressionRule.evaluate(event);
    }
}

