/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.net.DefaultEvaluator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SMTPAppender
extends AppenderSkeleton {
    private String to;
    private String from;
    private String subjectStr = "";
    private String smtpHost;
    private String charset = "ISO-8859-1";
    private int bufferSize = 512;
    private boolean locationInfo = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected MimeMessage msg;
    protected TriggeringEventEvaluator evaluator;
    private PatternLayout subjectLayout;
    static /* synthetic */ Class class$org$apache$log4j$spi$TriggeringEventEvaluator;

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator evaluator) {
        super(false);
        this.evaluator = evaluator;
    }

    public void activateOptions() {
        int errorCount = 0;
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        Session session = Session.getInstance((Properties)props, null);
        this.msg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
        }
        catch (MessagingException e) {
            ++errorCount;
            this.getLogger().error((Object)"Could not activate SMTPAppender options.", (Throwable)e);
        }
        if (this.subjectStr != null) {
            this.subjectLayout = new PatternLayout();
            this.subjectLayout.setConversionPattern(this.subjectStr);
            this.subjectLayout.setLoggerRepository(this.repository);
            this.subjectLayout.activateOptions();
        }
        if (this.evaluator == null) {
            ++errorCount;
            String errMsg = "No TriggeringEventEvaluator is set for appender [" + this.getName() + "].";
            this.getLogger().error((Object)errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (this.layout == null) {
            ++errorCount;
            String errMsg = "No layout set for appender named [" + this.name + "].";
            this.getLogger().error((Object)errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (errorCount == 0) {
            super.activateOptions();
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        event.getThreadName();
        event.getNDC();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        this.cb.add(event);
        if (this.evaluator.isTriggeringEvent(event)) {
            this.sendBuffer(event);
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            return false;
        }
        if (this.evaluator == null) {
            return false;
        }
        return this.layout != null;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.getLogger().error((Object)("Could not parse address [" + addressStr + "]."), (Throwable)e);
            return null;
        }
    }

    InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse((String)addressStr, (boolean)true);
        }
        catch (AddressException e) {
            this.getLogger().error((Object)("Could not parse address [" + addressStr + "]."), (Throwable)e);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer(LoggingEvent triggeringEvent) {
        try {
            MimeBodyPart part = new MimeBodyPart();
            String computedSubject = this.computeSubject(triggeringEvent);
            this.msg.setSubject(computedSubject, this.charset);
            StringBuffer sbuf = new StringBuffer();
            String t = this.layout.getHeader();
            if (t != null) {
                sbuf.append(t);
            }
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s;
                LoggingEvent event = this.cb.get();
                sbuf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    sbuf.append(s[j]);
                    sbuf.append(Layout.LINE_SEP);
                }
            }
            t = this.layout.getFooter();
            if (t != null) {
                sbuf.append(t);
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType() + ";charset=" + this.charset);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error occured while sending e-mail notification.", (Throwable)e);
        }
    }

    String computeSubject(LoggingEvent triggeringEvent) {
        if (this.subjectLayout != null) {
            return this.subjectLayout.format(triggeringEvent);
        }
        return null;
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subjectStr = subject;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.cb.resize(bufferSize);
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String value) {
        this.getLogger().warn((Object)"The SMPTAppender.setEvaluatorClass is deprecated.");
        this.getLogger().warn((Object)"It has been replaced with the more powerful SMPTAppender.setEvaluator method.");
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)value, (Class)(class$org$apache$log4j$spi$TriggeringEventEvaluator == null ? (class$org$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.apache.log4j.spi.TriggeringEventEvaluator")) : class$org$apache$log4j$spi$TriggeringEventEvaluator), (Object)this.evaluator);
    }

    public void setEvaluator(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

