/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lbel;

public final class Operator {
    public static final int EQUAL = 1;
    public static final int NOT_EQUAL = 2;
    public static final int GREATER = 10;
    public static final int GREATER_OR_EQUAL = 11;
    public static final int LESS = 20;
    public static final int LESS_OR_EQUAL = 21;
    public static final int REGEX_MATCH = 30;
    public static final int NOT_REGEX_MATCH = 31;
    public static final int CHILDOF = 40;
    int code;

    Operator(int code) {
        this.code = code;
        switch (code) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 40: {
                break;
            }
            default: {
                new IllegalArgumentException("Unknown operator code [" + code + "]");
            }
        }
    }

    public int getCode() {
        return this.code;
    }

    public boolean isRegex() {
        return this.code == 30 || this.code == 31;
    }

    public String toString() {
        switch (this.code) {
            case 1: {
                return "=";
            }
            case 2: {
                return "!=";
            }
            case 10: {
                return ">";
            }
            case 11: {
                return ">=";
            }
            case 20: {
                return "<";
            }
            case 21: {
                return "<=";
            }
            case 30: {
                return "~";
            }
            case 31: {
                return "!~";
            }
            case 40: {
                return "CHILDOF";
            }
        }
        return "UNKNOWN_OPERATOR";
    }
}

