/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public abstract class AppenderSkeleton
extends ComponentBase
implements Appender,
OptionHandler {
    protected Layout layout;
    protected String name;
    protected Priority threshold;
    protected ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    protected Filter headFilter;
    protected Filter tailFilter;
    protected boolean closed = false;
    protected boolean active;
    private boolean guard = false;

    public AppenderSkeleton() {
        this.active = true;
    }

    protected AppenderSkeleton(boolean isActive) {
        this.active = isActive;
    }

    public void activateOptions() {
        this.active = true;
    }

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    protected abstract void append(LoggingEvent var1);

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        this.getLogger().debug((Object)"Finalizing appender named [{}].", this.name);
        this.close();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public final String getName() {
        return this.name;
    }

    public Priority getThreshold() {
        return this.threshold;
    }

    public boolean isAsSevereAsThreshold(Priority level) {
        return this.threshold == null || level.isGreaterOrEqual(this.threshold);
    }

    public boolean isAsSevereAsThreshold(Level level) {
        return this.threshold == null || level.isGreaterOrEqual(this.threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doAppend(LoggingEvent event) {
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (this.closed) {
                this.getNonFloodingLogger().error((Object)"Attempted to append to closed appender named [{}].", this.name);
                return;
            }
            if (!this.active) {
                this.getNonFloodingLogger().error((Object)"Attempted to log with inactive appender named [{}].", this.name);
                return;
            }
            if (!this.isAsSevereAsThreshold(event.getLevel())) {
                return;
            }
            Filter f = this.headFilter;
            block12: while (f != null) {
                switch (f.decide(event)) {
                    case -1: {
                        return;
                    }
                    case 1: {
                        break block12;
                    }
                    case 0: {
                        f = f.getNext();
                    }
                    default: {
                        continue block12;
                    }
                }
            }
            this.append(event);
        }
        finally {
            this.guard = false;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isActive() {
        return this.active && !this.closed;
    }

    public void setErrorHandler(ErrorHandler eh) {
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreshold(Priority threshold) {
        this.threshold = threshold;
    }
}

