/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.IntializationUtil;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.scheduler.Scheduler;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.HierarchyEventListenerAdapter;
import org.apache.log4j.spi.LoggerEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepositoryEventListener;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.RendererSupport;

public class Hierarchy
implements LoggerRepositoryEx,
RendererSupport {
    private LoggerFactory defaultFactory;
    private final ArrayList repositoryEventListeners;
    private final ArrayList loggerEventListeners;
    String name;
    Hashtable ht;
    Logger root;
    RendererMap rendererMap;
    int thresholdInt;
    Level threshold;
    PluginRegistry pluginRegistry;
    Map properties;
    private Scheduler scheduler;
    private Map objectMap;
    private Logger myLogger;
    private List errorList = new Vector();
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;
    boolean pristine = true;

    public Hierarchy(Logger root) {
        this.ht = new Hashtable();
        this.repositoryEventListeners = new ArrayList(1);
        this.loggerEventListeners = new ArrayList(1);
        this.root = root;
        this.objectMap = new HashMap();
        this.setThreshold(Level.ALL);
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.rendererMap.setLoggerRepository(this);
        this.properties = new Hashtable();
        this.defaultFactory = new DefaultCategoryFactory();
    }

    public void addRenderer(Class classToRender, ObjectRenderer or) {
        this.rendererMap.put(classToRender, or);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (this.repositoryEventListeners.contains(listener)) {
                this.getMyLogger().warn("Ignoring attempt to add a previously registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.add(listener);
            }
        }
    }

    private Logger getMyLogger() {
        if (this.myLogger == null) {
            this.myLogger = this.getLogger(this.getClass().getName());
        }
        return this.myLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (!this.repositoryEventListeners.contains(listener)) {
                this.getMyLogger().warn("Ignoring attempt to remove a non-registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoggerEventListener(LoggerEventListener listener) {
        ArrayList arrayList = this.loggerEventListeners;
        synchronized (arrayList) {
            if (this.loggerEventListeners.contains(listener)) {
                this.getMyLogger().warn("Ignoring attempt to add a previously registerd LoggerEventListener.");
            } else {
                this.loggerEventListeners.add(listener);
            }
        }
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
        this.addLoggerEventListener(new HierarchyEventListenerAdapter(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoggerEventListener(LoggerEventListener listener) {
        ArrayList arrayList = this.loggerEventListeners;
        synchronized (arrayList) {
            if (!this.loggerEventListeners.contains(listener)) {
                this.getMyLogger().warn("Ignoring attempt to remove a non-registered LoggerEventListener.");
            } else {
                this.loggerEventListeners.remove(listener);
            }
        }
    }

    public void clear() {
        this.ht.clear();
    }

    public void emitNoAppenderWarning(Category cat) {
        if (!this.emittedNoAppenderWarning) {
            this.emittedNoAppenderWarning = true;
        }
    }

    public Logger exists(String name) {
        Object o = this.ht.get(new CategoryKey(name));
        if (o instanceof Logger) {
            return (Logger)o;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String repoName) {
        if (this.name == null) {
            this.name = repoName;
        } else if (!this.name.equals(repoName)) {
            throw new IllegalStateException("Repository [" + this.name + "] cannot be renamed as [" + repoName + "].");
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setThreshold(String levelStr) {
        Level l = Level.toLevel(levelStr, null);
        if (l != null) {
            this.setThreshold(l);
        } else {
            this.getMyLogger().warn("Could not convert [" + levelStr + "] to Level.");
        }
    }

    public void setThreshold(Level l) {
        if (l != null) {
            this.thresholdInt = l.level;
            this.threshold = l;
        }
    }

    public PluginRegistry getPluginRegistry() {
        if (this.pluginRegistry == null) {
            this.pluginRegistry = new PluginRegistry(this);
        }
        return this.pluginRegistry;
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
        if (logger instanceof Logger) {
            this.fireAddAppenderEvent((Logger)logger, appender);
        }
    }

    public void fireAddAppenderEvent(Logger logger, Appender appender) {
        ArrayList list = this.copyListenerList(this.loggerEventListeners);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LoggerEventListener)list.get(i)).appenderAddedEvent(logger, appender);
        }
    }

    public void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (logger instanceof Logger) {
            this.fireRemoveAppenderEvent((Logger)logger, appender);
        }
    }

    public void fireRemoveAppenderEvent(Logger logger, Appender appender) {
        ArrayList list = this.copyListenerList(this.loggerEventListeners);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LoggerEventListener)list.get(i)).appenderRemovedEvent(logger, appender);
        }
    }

    public void fireLevelChangedEvent(Logger logger) {
        ArrayList list = this.copyListenerList(this.loggerEventListeners);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LoggerEventListener)list.get(i)).levelChangedEvent(logger);
        }
    }

    public void fireConfigurationChangedEvent() {
        ArrayList list = this.copyListenerList(this.repositoryEventListeners);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LoggerRepositoryEventListener)list.get(i)).configurationChangedEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList copyListenerList(ArrayList list) {
        ArrayList listCopy = null;
        ArrayList arrayList = list;
        synchronized (arrayList) {
            int size = list.size();
            listCopy = new ArrayList(size);
            for (int x = 0; x < size; ++x) {
                listCopy.add(list.get(x));
            }
        }
        return listCopy;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, this.defaultFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name, LoggerFactory factory) {
        CategoryKey key = new CategoryKey(name);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object o = this.ht.get(key);
            if (o == null) {
                LogLog.debug("Creating new logger [" + name + "] in repository [" + this.getName() + "].");
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateParents(logger);
                return logger;
            }
            if (o instanceof Logger) {
                LogLog.debug("Returning existing logger [" + name + "] in repository [" + this.getName() + "].");
                return (Logger)o;
            }
            if (o instanceof ProvisionNode) {
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateChildren((ProvisionNode)o, logger);
                this.updateParents(logger);
                return logger;
            }
            return null;
        }
    }

    public Enumeration getCurrentLoggers() {
        Vector v = new Vector(this.ht.size());
        Enumeration elems = this.ht.elements();
        while (elems.hasMoreElements()) {
            Object o = elems.nextElement();
            if (!(o instanceof Logger)) continue;
            v.addElement(o);
        }
        return v.elements();
    }

    public List getErrorList() {
        return this.errorList;
    }

    public void addErrorItem(ErrorItem errorItem) {
        this.getErrorList().add(errorItem);
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Logger getRootLogger() {
        return this.root;
    }

    public boolean isDisabled(int level) {
        return this.thresholdInt > level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConfiguration() {
        this.getRootLogger().setLevel(Level.DEBUG);
        this.root.setResourceBundle(null);
        this.setThreshold(Level.ALL);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            this.shutdown(true);
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                Logger c = (Logger)cats.nextElement();
                c.setLevel(null);
                c.setAdditivity(true);
                c.setResourceBundle(null);
            }
        }
        this.rendererMap.clear();
        ArrayList list = this.copyListenerList(this.repositoryEventListeners);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LoggerRepositoryEventListener)list.get(i)).configurationResetEvent(this);
        }
    }

    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererMap.put(renderedClass, renderer);
    }

    public boolean isPristine() {
        return this.pristine;
    }

    public void setPristine(boolean state) {
        this.pristine = state;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean doingReset) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        if (!doingReset) {
            ArrayList list = this.copyListenerList(this.repositoryEventListeners);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ((LoggerRepositoryEventListener)list.get(i)).shutdownEvent(this);
            }
        }
        Logger root = this.getRootLogger();
        root.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Logger c;
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c = (Logger)cats.nextElement();
                c.closeNestedAppenders();
            }
            root.removeAllAppenders();
            cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c = (Logger)cats.nextElement();
                c.removeAllAppenders();
            }
        }
        IntializationUtil.log4jInternalConfiguration(this);
    }

    private final void updateParents(Logger cat) {
        String name = cat.name;
        int length = name.length();
        boolean parentFound = false;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            String substr = name.substring(0, i);
            CategoryKey key = new CategoryKey(substr);
            Object o = this.ht.get(key);
            if (o == null) {
                ProvisionNode pn = new ProvisionNode(cat);
                this.ht.put(key, pn);
            } else {
                if (o instanceof Logger) {
                    parentFound = true;
                    cat.parent = (Logger)o;
                    break;
                }
                if (o instanceof ProvisionNode) {
                    ((ProvisionNode)o).addElement(cat);
                } else {
                    IllegalStateException e = new IllegalStateException("unexpected object type " + o.getClass() + " in ht.");
                    e.printStackTrace();
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (!parentFound) {
            cat.parent = this.root;
        }
    }

    private final void updateChildren(ProvisionNode pn, Logger logger) {
        int last = pn.size();
        for (int i = 0; i < last; ++i) {
            Logger l = (Logger)pn.elementAt(i);
            if (l.parent.name.startsWith(logger.name)) continue;
            logger.parent = l.parent;
            l.parent = logger;
        }
    }

    public Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            this.scheduler.setDaemon(true);
            this.scheduler.start();
        }
        return this.scheduler;
    }

    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    public Object getObject(String key) {
        return this.objectMap.get(key);
    }
}

