/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppender
extends AppenderSkeleton {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected Writer writer;

    public WriterAppender() {
        super(false);
    }

    public WriterAppender(Layout layout, OutputStream os) {
        this(layout, new OutputStreamWriter(os));
    }

    public WriterAppender(Layout layout, Writer writer) {
        super(false);
        this.layout = layout;
        this.setWriter(writer);
        this.activateOptions();
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void activateOptions() {
        int errors = 0;
        if (this.layout == null) {
            this.getLogger().error((Object)"No layout set for the appender named [{}].", this.name);
            ++errors;
        }
        if (this.writer == null) {
            this.getLogger().error((Object)"No writer set for the appender named [{}].", this.name);
            ++errors;
        }
        if (errors == 0) {
            super.activateOptions();
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(event);
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            this.getNonFloodingLogger().warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.writer == null) {
            this.getNonFloodingLogger().error((Object)"No output stream or file set for the appender named [{}].", this.name);
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeWriter();
    }

    protected void closeWriter() {
        if (this.writer != null) {
            try {
                this.writeFooter();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Could not close writer for WriterAppener named " + this.name), e);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter retval = null;
        String enc = this.getEncoding();
        if (enc != null) {
            try {
                retval = new OutputStreamWriter(os, enc);
            }
            catch (IOException e) {
                this.getLogger().warn("Error initializing output writer.");
                this.getLogger().warn("Unsupported encoding?");
            }
        }
        if (retval == null) {
            retval = new OutputStreamWriter(os);
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriter();
        this.writer = writer;
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent event) {
        if (!this.isActive()) {
            return;
        }
        try {
            String[] s;
            this.writer.write(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                int len = s.length;
                for (int i = 0; i < len; ++i) {
                    this.writer.write(s[i]);
                    this.writer.write(Layout.LINE_SEP);
                }
            }
            if (this.immediateFlush) {
                this.writer.flush();
            }
        }
        catch (IOException ioe) {
            this.active = false;
            this.getNonFloodingLogger().error((Object)("IO failure for appender named " + this.name), ioe);
        }
    }

    protected void xreset() {
        this.closeWriter();
    }

    protected void writeFooter() {
        String f;
        if (this.layout != null && (f = this.layout.getFooter()) != null && this.writer != null) {
            try {
                this.writer.write(f);
                this.writer.flush();
            }
            catch (IOException ioe) {
                this.active = false;
                this.getLogger().error((Object)("Failed to write footer for Appender named " + this.name), ioe);
            }
        }
    }

    protected void writeHeader() {
        String h;
        if (this.layout != null && (h = this.layout.getHeader()) != null && this.writer != null) {
            try {
                this.writer.write(h);
            }
            catch (IOException ioe) {
                this.active = false;
                this.getLogger().error((Object)("Failed to write header for WriterAppender named " + this.name), ioe);
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }
}

