/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.SyslogWriter;
import org.apache.log4j.spi.LoggingEvent;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    private static final String[] FACILITIES = new String[]{"kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", null, null, null, null, "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"};
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    static final String TAB = "    ";
    int syslogFacility = 8;
    String facilityStr = "user";
    boolean facilityPrinting = false;
    String localHostname;
    String syslogHost;
    private SyslogWriter sw;
    private final Calendar calendar = Calendar.getInstance();
    private long now = -1L;
    private Date date = new Date();
    private StringBuffer timestamp = new StringBuffer();
    private FieldPosition pos = new FieldPosition(0);
    private SimpleDateFormat sdf = new SimpleDateFormat("MMM dd hh:mm:ss", new DateFormatSymbols(Locale.US));
    private Layout layout;

    public SyslogAppender() {
        super(false);
    }

    public SyslogAppender(Layout layout, int syslogFacility) {
        super(false);
        this.layout = layout;
        this.syslogFacility = syslogFacility;
        String newFacilityStr = SyslogAppender.getFacilityString(syslogFacility);
        if (newFacilityStr != null) {
            this.facilityStr = newFacilityStr;
        }
    }

    public SyslogAppender(Layout layout, String syslogHost, int syslogFacility) {
        this(layout, syslogFacility);
        this.setSyslogHost(syslogHost);
    }

    public synchronized void close() {
        this.closed = true;
        this.sw = null;
    }

    public String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            this.getLogger().error((Object)("Could not determine local host name for SyslogAppendernamed [" + this.name + "]."), uhe);
            return "UNKNOWN_HOST";
        }
    }

    public static String getFacilityString(int syslogFacility) {
        int index;
        String facilityStr = null;
        if ((syslogFacility & 7) == 0 && (index = syslogFacility >> 3) >= 0 && index < FACILITIES.length) {
            facilityStr = FACILITIES[index];
        }
        return facilityStr;
    }

    public static int getFacility(String facilityStr) {
        int code = -1;
        if (facilityStr != null) {
            for (int i = 0; i < FACILITIES.length; ++i) {
                if (!facilityStr.equalsIgnoreCase(FACILITIES[i])) continue;
                code = i << 3;
                break;
            }
        }
        return code;
    }

    public void activateOptions() {
        if (this.facilityStr == null) {
            String errMsg = "The Facility option must be set for SyslogAppender named [" + this.name + "].";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.facilityStr = this.facilityStr.trim();
        this.getLogger().debug((Object)"Facility string set to be {}.", this.facilityStr);
        this.syslogFacility = SyslogAppender.getFacility(this.facilityStr);
        this.getLogger().debug("Facility set to be " + this.syslogFacility);
        if (this.syslogFacility == -1) {
            String errMsg = "Unrecognized Facility option \"" + this.facilityStr + "\" SyslogAppender named [" + this.name + "].";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (this.syslogHost == null) {
            String errMsg = "No syslog host is set for SyslogAppender named \"" + this.name + "\".";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (this.layout == null) {
            String errMsg = "No Layout is set for SyslogAppender named \"" + this.name + "\".";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.localHostname = this.getLocalHostname();
        this.sw = new SyslogWriter(this.syslogHost);
        super.activateOptions();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String facility) {
        if (facility != null) {
            this.syslogFacility = SyslogAppender.getFacility(facility);
            if (this.syslogFacility == -1) {
                System.err.println("[" + facility + "] is an unknown syslog facility. Defaulting to [USER].");
                this.syslogFacility = 8;
            }
            this.facilityStr = SyslogAppender.getFacilityString(this.syslogFacility);
        }
    }

    public String getFacility() {
        return this.facilityStr;
    }

    void fillInTimestamp() throws IOException {
        long n = System.currentTimeMillis();
        if ((n -= n & 0x3E8L) != this.now || this.timestamp.length() == 0) {
            this.now = n;
            this.date.setTime(n);
            this.timestamp.setLength(0);
            this.sdf.format(this.date, this.timestamp, this.pos);
            if (this.timestamp.charAt(4) == '0') {
                this.timestamp.setCharAt(4, ' ');
            }
        }
        this.sw.write(this.timestamp.toString());
    }

    void writeInitialParts(LoggingEvent event) throws IOException {
        int pri = this.syslogFacility + event.getLevel().getSyslogEquivalent();
        System.out.println("" + pri);
        this.sw.write("<");
        this.sw.write(String.valueOf(pri));
        this.sw.write(">");
        this.fillInTimestamp();
        this.sw.write(32);
        this.sw.write(this.localHostname);
        this.sw.write(32);
    }

    public void append(LoggingEvent event) {
        if (this.sw == null) {
            return;
        }
        try {
            this.writeInitialParts(event);
            String msg = this.layout.format(event);
            this.sw.write(msg);
            this.sw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setFacilityPrinting(boolean on) {
        this.facilityPrinting = on;
    }

    public boolean getFacilityPrinting() {
        return this.facilityPrinting;
    }
}

