/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class InFixToPostFix {
    private final Map precedenceMap = new HashMap();
    private final List operators = new Vector();

    public InFixToPostFix() {
        this.operators.add("!");
        this.operators.add("!=");
        this.operators.add("==");
        this.operators.add("~=");
        this.operators.add("||");
        this.operators.add("&&");
        this.operators.add("like");
        this.operators.add("exists");
        this.operators.add("<");
        this.operators.add(">");
        this.operators.add("<=");
        this.operators.add(">=");
        this.precedenceMap.put("<", new Integer(3));
        this.precedenceMap.put(">", new Integer(3));
        this.precedenceMap.put("<=", new Integer(3));
        this.precedenceMap.put(">=", new Integer(3));
        this.precedenceMap.put("!", new Integer(3));
        this.precedenceMap.put("!=", new Integer(3));
        this.precedenceMap.put("==", new Integer(3));
        this.precedenceMap.put("~=", new Integer(3));
        this.precedenceMap.put("like", new Integer(3));
        this.precedenceMap.put("exists", new Integer(3));
        this.precedenceMap.put("||", new Integer(2));
        this.precedenceMap.put("&&", new Integer(2));
    }

    public String convert(String expression) {
        return this.infixToPostFix(new StringTokenizer(expression));
    }

    boolean isOperand(String symbol) {
        return !this.operators.contains(symbol = symbol.toLowerCase());
    }

    boolean precedes(String symbol1, String symbol2) {
        int index2;
        symbol1 = symbol1.toLowerCase();
        symbol2 = symbol2.toLowerCase();
        if (!this.precedenceMap.keySet().contains(symbol1)) {
            return false;
        }
        if (!this.precedenceMap.keySet().contains(symbol2)) {
            return false;
        }
        int index1 = (Integer)this.precedenceMap.get(symbol1);
        boolean precedesResult = index1 < (index2 = ((Integer)this.precedenceMap.get(symbol2)).intValue());
        return precedesResult;
    }

    String infixToPostFix(StringTokenizer tokenizer) {
        String SPACE = " ";
        StringBuffer postfix = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        while (tokenizer.hasMoreTokens()) {
            boolean inText;
            String token = tokenizer.nextToken();
            boolean bl = inText = token.startsWith("'") && !token.endsWith("'");
            if (inText) {
                while (inText && tokenizer.hasMoreTokens()) {
                    inText = !(token = token + " " + tokenizer.nextToken()).endsWith("'");
                }
            }
            if ("(".equals(token)) {
                postfix.append(this.infixToPostFix(tokenizer));
                postfix.append(SPACE);
                continue;
            }
            if (")".equals(token)) {
                while (stack.size() > 0) {
                    postfix.append(stack.pop().toString());
                    postfix.append(SPACE);
                }
                return postfix.toString();
            }
            if (this.isOperand(token)) {
                postfix.append(token);
                postfix.append(SPACE);
                continue;
            }
            if (stack.size() > 0) {
                String peek = stack.peek().toString();
                if (this.precedes(peek, token)) {
                    stack.push(token);
                    continue;
                }
                boolean bypass = false;
                do {
                    if (stack.size() > 0 && !this.precedes(stack.peek().toString(), token)) {
                        postfix.append(stack.pop().toString());
                        postfix.append(SPACE);
                        continue;
                    }
                    bypass = true;
                } while (!bypass);
                stack.push(token);
                continue;
            }
            stack.push(token);
        }
        while (stack.size() > 0) {
            postfix.append(stack.pop().toString());
            postfix.append(SPACE);
        }
        return postfix.toString();
    }
}

