/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.net.URL;
import javax.xml.parsers.SAXParser;
import org.apache.log4j.LogManager;
import org.apache.log4j.joran.JoranConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DOMConfigurator
extends JoranConfigurator {
    public static void configure(String file) {
        JoranConfigurator joran = new JoranConfigurator();
        joran.doConfigure(file, LogManager.getLoggerRepository());
    }

    public static void configure(URL url) {
        JoranConfigurator joran = new JoranConfigurator();
        joran.doConfigure(url, LogManager.getLoggerRepository());
    }

    public static void configure(Element element) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure(element, LogManager.getLoggerRepository());
    }

    public void doConfigure(Element element, LoggerRepository repository) {
        DOMElementParseAction action = new DOMElementParseAction(element);
        this.doConfigure(action, repository);
    }

    private static class DOMElementParseAction
    implements JoranConfigurator.ParseAction {
        private final Element element;
        private final AttributesImpl attributes = new AttributesImpl();

        public DOMElementParseAction(Element element) {
            this.element = element;
        }

        public void parse(SAXParser parser, DefaultHandler handler) throws SAXException {
            handler.startDocument();
            this.replay(this.element, handler);
            handler.endDocument();
        }

        private void replay(Element element, DefaultHandler handler) throws SAXException {
            String localName = element.getLocalName();
            String nsURI = element.getNamespaceURI();
            String qName = element.getNodeName();
            if (localName == null) {
                localName = qName;
            }
            this.attributes.clear();
            NamedNodeMap attrNodes = element.getAttributes();
            int attrCount = attrNodes.getLength();
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attrNodes.item(i);
                String attrQName = attr.getNodeName();
                String attrName = attr.getLocalName();
                if (attrName == null) {
                    attrName = attrQName;
                }
                String attrNsURI = attr.getNamespaceURI();
                String attrValue = attr.getNodeValue();
                this.attributes.addAttribute(attrNsURI, attrName, attrQName, "#PCDATA", attrValue);
            }
            handler.startElement(nsURI, localName, qName, this.attributes);
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                this.replay((Element)child, handler);
            }
            handler.endElement(nsURI, localName, qName);
        }
    }
}

